﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;
using BMS.Web.App_GlobalResource;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model for MaintainMarquee view.
    /// </summary>
    public class MaintainMarqueeModel : BaseViewModel
    {
        public string ActiveIndex { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText1 { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText2 { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText3 { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText4 { get; set; }

        [AllowHtml]
        [StringLength(200, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "MaintainMarqueeErrorMarqueeTextBad")]
        public string MarqueeText5 { get; set; }

        internal void ConfigureModelFromSettings(MarqueeSettings settings)
        {
            if (settings == null)
                return;

            MarqueeText1 = GetMarqueeTextFromSettings(settings, "1");
            MarqueeText2 = GetMarqueeTextFromSettings(settings, "2");
            MarqueeText3 = GetMarqueeTextFromSettings(settings, "3");
            MarqueeText4 = GetMarqueeTextFromSettings(settings, "4");
            MarqueeText5 = GetMarqueeTextFromSettings(settings, "5");

            ActiveIndex = settings.ActiveIndex;
            MarqueeText = settings.ActiveMarqueeText;
        }

        private static string GetMarqueeTextFromSettings(MarqueeSettings settings, string index)
        {
            MarqueeItem item = settings != null && settings.Items.ContainsKey(index) ? settings.Items[index] : null;
            if (item != null)
            {
                AntiXssEncoder xss = new AntiXssEncoder();
                string itemText = xss.Decode(item.Text);
                return HtmlSanitizerUtility.Instance.CssDecode(itemText);
            }

            return String.Empty;
        }

        internal MarqueeSettings ToSettings()
        {
            MarqueeSettings settings = new MarqueeSettings();

            AddMarqueeItem(settings, "1", MarqueeText1);
            AddMarqueeItem(settings, "2", MarqueeText2);
            AddMarqueeItem(settings, "3", MarqueeText3);
            AddMarqueeItem(settings, "4", MarqueeText4);
            AddMarqueeItem(settings, "5", MarqueeText5);

            settings.ActiveIndex = ActiveIndex;

            return settings;
        }

        private void AddMarqueeItem(MarqueeSettings settings, string index, string text)
        {
            if (!String.IsNullOrEmpty(MarqueeText1))
            {
                string itemText = HtmlSanitizerUtility.Instance.CssDecode(text);
                settings.Items.Add(index, new MarqueeItem() { Index = index, Text = itemText });
            }
        }
    }
}